<?php
/**
 *  Module made by Nukium
 *
 *  @author    Nukium
 *  @copyright 2018 Nukium SAS
 *  @license   All rights reserved
 *
 * ███    ██ ██    ██ ██   ██ ██ ██    ██ ███    ███
 * ████   ██ ██    ██ ██  ██  ██ ██    ██ ████  ████
 * ██ ██  ██ ██    ██ █████   ██ ██    ██ ██ ████ ██
 * ██  ██ ██ ██    ██ ██  ██  ██ ██    ██ ██  ██  ██
 * ██   ████  ██████  ██   ██ ██  ██████  ██      ██
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

class Nkmaccountalert extends Module
{
    protected $config_form = false;

    public function __construct()
    {
        $this->name = 'nkmaccountalert';
        $this->tab = 'administration';
        $this->version = '1.3.1';
        $this->author = 'Nukium';
        $this->module_key = '925a21383423dbda4d84285af967bfe2';
        $this->need_instance = 0;

        $this->bootstrap = true;

        $this->ps_versions_compliancy = array(
            'min' => '1.6',
            'max' => _PS_VERSION_
        );

        $this->displayName = $this->l('Account registration alert');
        $this->description = $this->l('Be notified automatically when a customer account was created.');

        parent::__construct();
    }

    /**
     * Don't forget to create update methods if needed:
     */
    public function install()
    {
        Configuration::updateValue('NKMACCOUNTALERT_CREATE_ALERT', 1);
        Configuration::updateValue('NKMACCOUNTALERT_UPDATE_ALERT', 0);

        return parent::install()
            && $this->registerHook('actionCustomerAccountAdd')
            && $this->registerHook('actionObjectCustomerUpdateAfter')
            && $this->registerHook('actionObjectAddressAddAfter')
            && $this->registerHook('actionObjectAddressUpdateAfter');
    }

    public function uninstall()
    {
        Configuration::deleteByName('NKMACCOUNTALERT_CREATE_ALERT');
        Configuration::deleteByName('NKMACCOUNTALERT_UPDATE_ALERT');

        return parent::uninstall();
    }

    /**
     * Load the configuration form
     */
    public function getContent()
    {
        $this->html = '';

        /**
         * If values have been submitted in the form, process.
         */
        if ((bool)Tools::isSubmit('submitNkmaccountalertModule') == true) {
            $this->html .= $this->postProcess();
        }

        $this->context->smarty->assign('module_dir', $this->_path);

        $footer = $this->context->smarty->fetch($this->local_path . 'views/templates/admin/configure.tpl');

        $this->html .= $this->renderForm();

        return $this->html . $footer;
    }

    /**
     * Create the form that will be displayed in the configuration of your module.
     */
    protected function renderForm()
    {
        $helper = new HelperForm();

        $helper->show_toolbar = false;
        $helper->table = $this->table;
        $helper->module = $this;
        $helper->default_form_language = $this->context->language->id;
        $helper->allow_employee_form_lang = Configuration::get('PS_BO_ALLOW_EMPLOYEE_FORM_LANG', 0);

        $helper->identifier = $this->identifier;
        $helper->submit_action = 'submitNkmaccountalertModule';
        $helper->currentIndex = $this->context->link->getAdminLink('AdminModules', false)
            .'&configure='.$this->name.'&tab_module='.$this->tab.'&module_name='.$this->name;
        $helper->token = Tools::getAdminTokenLite('AdminModules');

        $helper->tpl_vars = array(
            'fields_value' => $this->getConfigFormValues(),
            'languages' => $this->context->controller->getLanguages(),
            'id_language' => $this->context->language->id,
        );

        return $helper->generateForm(array($this->getConfigForm()));
    }

    /**
     * Create the structure of your form.
     */
    protected function getConfigForm()
    {
        return array(
            'form' => array(
                'legend' => array(
                'title' => $this->l('Settings'),
                'icon' => 'icon-cogs',
                ),
                'input' => array(
                    array(
                        'type' => 'textarea',
                        'prefix' => '<i class="icon icon-envelope"></i>',
                        'desc' => $this->l('Enter valid email address, one email by line'),
                        'name' => 'NKMACCOUNTALERT_EMAIL',
                        'label' => $this->l('Email'),
                    ),
                    array(
                        'type' => 'textarea',
                        'prefix' => '<i class="icon icon-envelope"></i>',
                        'desc' => $this->l('Enter valid email address, one email by line'),
                        'name' => 'NKMACCOUNTALERT_EMAIL_BCC',
                        'label' => $this->l('Email Bcc'),
                    ),
                    array(
                        'type' => 'switch',
                        'label' => $this->l('Send an email after customer account update'),
                        'name' => 'NKMACCOUNTALERT_UPDATE_ALERT',
                        'required' => true,
                        'is_bool' => true,
                        'values' => array(
                            array(
                                'id' => 'active_on',
                                'value' => 1,
                                'label' => $this->l('Yes')
                            ),
                            array(
                                'id' => 'active_off',
                                'value' => 0,
                                'label' => $this->l('No')
                            )
                        ),
                        'lang' => false,
                        'hint' => $this->l('Send a notification email each time a customer changes or updates their address or profile information.'),
                    ),
                    array(
                        'type' => 'switch',
                        'label' => $this->l('Send an email after customer account create'),
                        'name' => 'NKMACCOUNTALERT_CREATE_ALERT',
                        'required' => true,
                        'is_bool' => true,
                        'values' => array(
                            array(
                                'id' => 'active_on',
                                'value' => 1,
                                'label' => $this->l('Yes')
                            ),
                            array(
                                'id' => 'active_off',
                                'value' => 0,
                                'label' => $this->l('No')
                            )
                        ),
                        'lang' => false,
                    )
                ),
                'submit' => array(
                    'title' => $this->l('Save'),
                ),
            ),
        );
    }

    /**
     * Set values for the inputs.
     */
    protected function getConfigFormValues()
    {
        $config = array();

        $emails = unserialize(Configuration::get('NKMACCOUNTALERT_EMAIL', ''));
        if ($emails && count($emails)>0) {
            $config['NKMACCOUNTALERT_EMAIL'] = implode("\r\n", $emails);
        } else {
            $config['NKMACCOUNTALERT_EMAIL'] = Configuration::get('NKMACCOUNTALERT_EMAIL', '');
        }

        $emails_bcc = unserialize(Configuration::get('NKMACCOUNTALERT_EMAIL_BCC', ''));
        if ($emails_bcc && count($emails_bcc)>0) {
            $config['NKMACCOUNTALERT_EMAIL_BCC'] = implode("\r\n", $emails_bcc);
        } else {
            $config['NKMACCOUNTALERT_EMAIL_BCC'] = Configuration::get('NKMACCOUNTALERT_EMAIL_BCC', '');
        }

        $config['NKMACCOUNTALERT_UPDATE_ALERT'] = Tools::getValue(
            'NKMACCOUNTALERT_UPDATE_ALERT',
            Configuration::get('NKMACCOUNTALERT_UPDATE_ALERT', '')
        );

        $config['NKMACCOUNTALERT_CREATE_ALERT'] = Tools::getValue(
            'NKMACCOUNTALERT_CREATE_ALERT',
            Configuration::get('NKMACCOUNTALERT_CREATE_ALERT', '')
        );

        return $config;
    }

    /**
     * Save form data.
     */
    protected function postProcess()
    {
        $output = null;

        $form_values = $this->getConfigFormValues();

        foreach ($form_values as $key => $value) {
            if ($key == 'NKMACCOUNTALERT_EMAIL' || $key == 'NKMACCOUNTALERT_EMAIL_BCC') {
                if (Tools::getValue($key)) {
                    $emails = preg_split("/\\r\\n|\\r|\\n|,|;| /", Tools::getValue($key));

                    foreach ($emails as $k => $v) {
                        $emails[$k] = trim($v);
                        if (!empty($emails[$k])) {
                            if (!Validate::isEmail($emails[$k])) {
                                $output .= $this->displayError(sprintf($this->l('Email "%s" is invalid !'), $emails[$k]));
                                unset($emails[$k]);
                            }
                        } else {
                            unset($emails[$k]);
                        }
                    }

                    if (!empty($emails)) {
                        $emails = serialize($emails);
                    } else {
                        $emails = '';
                    }
                } else {
                    $emails = '';
                }
                Configuration::updateValue($key, $emails);
            } else {
                Configuration::updateValue($key, $value);
            }
        }

        if (!$output) {
            $output = $this->displayConfirmation($this->l('Settings updated'));
        }

        if ($output) {
            return $output;
        }
    }

    /**
     * Send email after an account creation
     * @param array $params
     */
    public function hookActionCustomerAccountAdd($params, $_from = '', $_address = null)
    {
        $customer = $params['newCustomer'];
        //__ Emails admin destinataires
        $emails = unserialize(Configuration::get('NKMACCOUNTALERT_EMAIL', null, $this->context->shop->id_shop_group, $this->context->shop->id));
        //__ Langue par défaut de la boutique
        $id_lang_default = Configuration::get('PS_LANG_DEFAULT', null, $this->context->shop->id_shop_group, $this->context->shop->id);

        if (!empty($emails) &&
            !empty($customer) &&
            Validate::isLoadedObject($customer) &&
            (!empty($_from) || (empty($_from) && Configuration::get('NKMACCOUNTALERT_CREATE_ALERT')))
        ) {
            $vars = array(
                '{firstname}' => $customer->firstname,
                '{lastname}' => $customer->lastname,
                '{email}' => $customer->email,
                '{birhtday}' => $customer->birthday,
                '{newsletter}' => '',
                '{optin}' => ''
            );

            if ($customer->newsletter) {
                $vars['{newsletter}'] = $this->l('The customer has subscribed to the newsletter.');
                //$vars['{newsletter}'] = Mail::l('The customer has subscribed to the newsletter.', (int)$id_lang_default);
            }

            if ($customer->optin) {
                $vars['{optin}'] = $this->l('The customer agrees to receive offers from our partners.');
                //$vars['{optin}'] = Mail::l('The customer agrees to receive offers from our partners.', (int)$id_lang_default);
            }

            $address = array();
            if (!is_null($_address) && Validate::isLoadedObject($_address)) {
                $address = get_object_vars($_address);
                if ($address['deleted']) {
                    return '';
                }
                if (empty($address['country'])) {
                    $address['country'] = Country::getNameById((int)$id_lang_default, $_address->id_country);
                }
            } else {
                $addresses = $customer->getAddresses((int)$id_lang_default);
                if (is_array($addresses) && count($addresses) > 0) {
                    $address = $addresses[0];
                }
            }

            if (!empty($address)) {
                $vars = array_merge($vars, array(
                    '{company}' => (isset($address['company']) ? $address['company'] : ''),
                    '{address1}' => (isset($address['address1']) ? $address['address1'] : ''),
                    '{address2}' => (isset($address['address2']) ? $address['address2'] : ''),
                    '{postcode}' => (isset($address['postcode']) ? $address['postcode'] : ''),
                    '{city}' => (isset($address['city']) ? $address['city'] : ''),
                    '{state}' => (isset($address['state']) ? $address['state'] : ''),
                    '{country}' => $address['country'],
                    '{phone}' => (isset($address['phone']) ? $address['phone'] : ''),
                    '{phone_mobile}' => (isset($address['phone_mobile']) ? $address['phone_mobile'] : ''),
                    '{vat_number}' => (isset($address['vat_number']) ? $address['vat_number'] : ''),
                    '{dni}' => (isset($address['dni']) ? $address['dni'] : '')));
            } else {
                $vars = array_merge($vars, array(
                    '{company}' => '',
                    '{address1}' => '',
                    '{address2}' => '',
                    '{postcode}' => '',
                    '{city}' => '',
                    '{state}' => '',
                    '{country}' => '',
                    '{phone}' => '',
                    '{phone_mobile}' => '',
                    '{vat_number}' => '',
                    '{dni}' => ''));
            }

            $this->context->smarty->assign(array(
                'customer' => $customer,
                'address' => $address,
                'content_type' => 'html',
                'source' => $_from,
            ));
            $html = $this->context->smarty->fetch($this->local_path . 'views/templates/hook/email.tpl');

            $this->context->smarty->assign(array(
                'customer' => $customer,
                'address' => $address,
                'content_type' => 'txt',
                'source' => $_from,
            ));
            $txt = $this->context->smarty->fetch($this->local_path . 'views/templates/hook/email.tpl');

            $vars = array_merge($vars, array(
                '{customer_detail_txt}' => strip_tags($txt),
                '{customer_detail_html}' => $html,
            ));

            //__ Emails admin en copie cachée
            $emails_bcc = unserialize(Configuration::get('NKMACCOUNTALERT_EMAIL_BCC', null, $this->context->shop->id_shop_group, $this->context->shop->id));
            //$subject = Mail::l('New account on your shop', (int)$id_lang_default);
            if (!empty($_from) && $_from == 'identity') {
                $subject = $this->l('Customer account update on your shop');
                $vars = array_merge($vars, array('{action_type}' => $this->l('has updated their account')));
            } elseif (!empty($_from) && $_from == 'address') {
                $subject = $this->l('Customer account update on your shop');
                $vars = array_merge($vars, array('{action_type}' => $this->l('has updated or created an address')));
            } else {
                $subject = $this->l('New account on your shop');
                $vars = array_merge($vars, array('{action_type}' => $this->l('has created an account')));
            }

            if (!empty($emails_bcc)) {
                //__ Avant la version 1.7.1.0 on ne peut pas définir plusieurs BCC dans un envoi de mail
                if (version_compare(_PS_VERSION_, '1.7.1.0', '<')) {
                    foreach ($emails_bcc as $value) {
                        Mail::Send(
                            $id_lang_default,
                            'nkmaccountalert',
                            $subject,
                            $vars,
                            $value,
                            null,
                            null,
                            null,
                            null,
                            null,
                            dirname(__FILE__).'/mails/',
                            false,
                            $this->context->shop->id
                        );
                    }
                    $emails_bcc = null;
                }
            } else {
                $emails_bcc = null;
            }

            return Mail::Send(
                $id_lang_default,
                'nkmaccountalert',
                $subject,
                $vars,
                $emails,
                null,
                null,
                null,
                null,
                null,
                dirname(__FILE__).'/mails/',
                false,
                $this->context->shop->id,
                $emails_bcc
            );
        }
    }

    /**
     * Send email after an account creation
     * @param array $params
     */
    public function hookActionObjectCustomerUpdateAfter($params)
    {
        if (Tools::isSubmit('submitIdentity') && Configuration::get('NKMACCOUNTALERT_UPDATE_ALERT')) {
            $this->hookActionCustomerAccountAdd(array('newCustomer' => $params['object']), 'identity');
        }
    }

    /**
     * Modification / création d'une adresse
     * @param array $params
     */
    public function hookActionObjectAddressAddAfter($params)
    {
        if (Tools::isSubmit('submitAddress') && Configuration::get('NKMACCOUNTALERT_UPDATE_ALERT')) {
            $this->hookActionCustomerAccountAdd(array('newCustomer' => new Customer($params['object']->id_customer)), 'address', $params['object']);
        }
    }

    public function hookActionObjectAddressUpdateAfter($params)
    {
        $this->hookActionObjectAddressAddAfter($params);
    }
}
