<?php
/**
 *  2017-2018 Profileo
 *
 *  @author    Profileo <contact@profileo.com>
 *  @copyright 2017-2018 Profileo
 *  @license   Profileo
 */

class OrderOpcController extends OrderOpcControllerCore
{

    protected function _getPaymentMethods()
    {
        /* #eo_orderreference START */
        $module = Module::getInstanceByName('eo_orderreference');
        if ($module && $module->active) {
            if (Configuration::get('PS_ORDER_PROCESS_TYPE') == 1
                && (int) Configuration::get('EO_ORDER_REF_REQUIRED')
                && ! $module->getOrderRefByIdCart($this->context->cart->id)) {
                return '<p class="warning">' . $module->l('An order reference is required') . '</p>';
            }
        }
        return parent::_getPaymentMethods();
        /* #eo_orderreference END */
    }
}
