<?php
/**
*  2017-2018 Profileo
*
*  @author    Profileo <contact@profileo.com>
*  @copyright 2017-2018 Profileo
*  @license   Profileo
*/

if (!defined('_PS_VERSION_')) {
    exit;
}

class Eo_orderreference extends Module
{
    public function __construct()
    {
        $this->name = 'eo_orderreference';
        $this->tab = 'checkout';
        $this->version = '1.0.2';
        $this->author = 'Profileo';
        $this->need_instance = 0;
        $this->module_key = 'de1b44f52434722459baeacda501a3e3';

        $this->bootstrap = true;

        parent::__construct();

        $this->displayName = $this->l('Personalized customer reference on order');
        $this->description = $this->l('Adds customisable fileds on cart overview');
    }

    public function install()
    {
        return parent::install() &&
            Configuration::updateValue('EO_ORDER_REF_INVOICE', true) &&
            Configuration::updateValue('EO_ORDER_REF_DELIVERY', true) &&
            $this->registerHook('header') &&
            $this->registerHook('backOfficeHeader') &&
            $this->registerHook('actionAdminOrdersListingFieldsModifier') &&
            $this->registerHook('displayAdminOrderTabOrder') &&
            $this->registerHook('displayOrderDetail') &&
            $this->registerHook('displayPDFInvoice') &&
            $this->registerHook('displayPDFDeliverySlip') &&
            $this->registerHook('displayShoppingCartFooter') &&
            $this->installDb();
    }

    public function uninstall()
    {
        return parent::uninstall() && $this->uninstallDb();
    }

    public function installDb()
    {
        $return = true;
        $sql = array();
        include(dirname(__FILE__).'/sql_install.php');
        foreach ($sql as $s) {
            $return &= Db::getInstance()->execute($s);
        }
        return $return;
    }
    public function uninstallDb()
    {
        $sql = array();
        include(dirname(__FILE__).'/sql_install.php');
        foreach ($sql as $name => $v) {
            Db::getInstance()->execute('DROP TABLE IF EXISTS '.$name);
        }
        return true;
    }

    public function getContent()
    {
        include dirname(__FILE__).'/lib/cross_selling_addons/CrossSellingHelper.php';
        
        $this->context->controller->addJS($this->_path.'views/js/back.js');
        $this->context->controller->addJS($this->_path.'views/js/iframeResizer.min.js');

        CrossSellingHelper::getHeader($this, dirname(__FILE__));
        return $this->renderIframe('top').$this->renderForm().CrossSellingHelper::getFooter($this, __FILE__);
    }

    public function renderForm()
    {
        $fields_form = array(
            'form' => array(
                'legend' => array(
                    'title' => $this->l("Configuration"),
                    'icon' => 'icon-cog'
                ),
                'input' => array(
                    array(
                        'type' => 'switch',
                        'label' => $this->l('Display on invoice'),
                        'name' => 'EO_ORDER_REF_INVOICE',
                        'values' => array(
                            array(
                                'id' => 'active_on',
                                'value' => 1,
                                'label' => $this->l('Enabled')
                            ),
                            array(
                                'id' => 'active_off',
                                'value' => 0,
                                'label' => $this->l('Disabled')
                            )
                        ),
                    ),
                    array(
                        'type' => 'switch',
                        'label' => $this->l('Display on deliveryslip'),
                        'name' => 'EO_ORDER_REF_DELIVERY',
                        'values' => array(
                            array(
                                'id' => 'active_on',
                                'value' => 1,
                                'label' => $this->l('Enabled')
                            ),
                            array(
                                'id' => 'active_off',
                                'value' => 0,
                                'label' => $this->l('Disabled')
                            )
                        ),
                    ),
                ),
                'submit' => array(
                    'title' => $this->l('Save'),
                )
            ),
        );

        $helper = new HelperForm();
        $helper->show_toolbar = false;
        $helper->table = $this->table;
        $lang = new Language((int)Configuration::get('PS_LANG_DEFAULT'));
        $helper->default_form_language = $lang->id;
        $bo_form_lang = Configuration::get('PS_BO_ALLOW_EMPLOYEE_FORM_LANG');
        $helper->allow_employee_form_lang = $bo_form_lang ? $bo_form_lang : 0;
        $this->fields_form = array();
        $helper->id = (int)Tools::getValue('id_match');
        $helper->identifier = $this->identifier;
        $helper->submit_action = 'btnSubmit';
        $helper->currentIndex = $this->context->link->getAdminLink('AdminModules', false).'&configure='.
            $this->name.'&tab_module='.
            $this->tab.'&module_name='.
            $this->name;

        $helper->token = Tools::getAdminTokenLite('AdminModules');
        $helper->tpl_vars = array(
            'fields_value' => $this->getConfigFieldsValues(),
            'languages' => $this->context->controller->getLanguages(),
            'id_language' => $this->context->language->id
        );

        return $helper->generateForm(array($fields_form));
    }

    public function getConfigFieldsValues()
    {
        $invoice = (int)Tools::getValue('EO_ORDER_REF_INVOICE', Configuration::get('EO_ORDER_REF_INVOICE'));
        $delivery = (int)Tools::getValue('EO_ORDER_REF_DELIVERY', Configuration::get('EO_ORDER_REF_DELIVERY'));

        return array(
            'EO_ORDER_REF_INVOICE' => $invoice,
            'EO_ORDER_REF_DELIVERY' => $delivery,
        );
    }

    public function renderIframe($type = 'top')
    {
        return '<iframe src="'.$this->getProfileoBannerUrl($type).'" 
            frameborder="0" class="eo_banner" style="width: 100%;margin: 15px 0;"></iframe>';
    }

    public function getOrderRefByIdOrder($id_order)
    {
        return Db::getInstance()->getValue('
                SELECT order_reference FROM `'._DB_PREFIX_.'eo_orderreference` eor
                LEFT JOIN `'._DB_PREFIX_.'orders` o on (o.id_cart = eor.id_cart)
                WHERE o.`id_order` = '.(int)$id_order);
    }

    public function getOrderRefByIdCart($id_cart)
    {
        return Db::getInstance()->getValue('
                SELECT order_reference
                FROM `'._DB_PREFIX_.'eo_orderreference`
                WHERE `id_cart` = '.(int)$id_cart);
    }

    public function setOrderRefByIdCart($id_cart, $order_reference)
    {
        return Db::getInstance()->execute('
            INSERT INTO `'._DB_PREFIX_.'eo_orderreference` (`id_cart`, `order_reference`)
            VALUES ('.(int)$id_cart.', \''.pSQL($order_reference).'\' )
            ON DUPLICATE KEY UPDATE `order_reference` = \''.pSQL($order_reference).'\'');
    }

    public function hookActionAdminOrdersListingFieldsModifier($params)
    {
        if (isset($params['select'])) {
            // bugfix : need to add a.`reference` AS `reference` or else it is somehow empty
            $params['select'] .= ', eoor.order_reference as order_reference, a.`reference` AS `reference`';
        }
        if (isset($params['join'])) {
            $params['join'] .= ' LEFT JOIN `'._DB_PREFIX_.'eo_orderreference` eoor ON (a.`id_cart` = eoor.`id_cart`) ';
        }
        $params['fields']['order_reference'] = array('title' => $this->l('Customer order #'));
    }

    public function hookDisplayAdminOrderTabOrder($params)
    {
        $order_reference = $this->getOrderRefByIdCart($params['order']->id_cart);
        $this->context->smarty->assign(array(
                'order_reference' => $order_reference,
                'id_cart' => $params['order']->id_cart,
                'eo_orderreference_token' => md5(_COOKIE_KEY_.$this->name)
                ));
        return $this->display(dirname(__FILE__), 'hook_bo_tab_order.tpl');
    }

    public function hookDisplayOrderDetail($params)
    {
        if ($order_reference = $this->getOrderRefByIdCart($params['order']->id_cart)) {
            $this->context->smarty->assign(
                array(
                    'order_reference' => $order_reference
                )
            );
            return $this->display(dirname(__FILE__), 'hook_fo_order-detail.tpl');
        }
    }

    public function hookDisplayPDFInvoice($params)
    {
        if (!Configuration::get('EO_ORDER_REF_INVOICE')) {
            return;
        }

        $order = new Order((int)$params['object']->id_order);
        if (Validate::isLoadedObject($order)) {
            if ($order_reference = $this->getOrderRefByIdCart($order->id_cart)) {
                $this->context->smarty->assign(array('order_reference' => $order_reference));
            }

            if (isset($params['deliveryslip'])) {
                $order_message = Db::getInstance()->getValue('
                        SELECT `message`
                        FROM `'._DB_PREFIX_.'customer_message` cm
                        LEFT JOIN `'._DB_PREFIX_.'customer_thread` ct
                        ON (ct.id_customer_thread = cm.id_customer_thread)
                        WHERE ct.id_order = '.(int)$order->id);

                $this->context->smarty->assign(array('order_message' => $order_message));
            }
            return $this->display(dirname(__FILE__), 'hook_pdf.tpl');
        }
    }

    public function hookDisplayPDFDeliverySlip($params)
    {
        if (!Configuration::get('EO_ORDER_REF_DELIVERY')) {
            return;
        }

        $params['deliveryslip'] = true;
        return $this->hookDisplayPDFInvoice($params);
    }

    public function hookDisplayShoppingCartFooter($params)
    {
        $order_reference = $this->getOrderRefByIdCart($params['cart']->id);
        if (!$order_reference) {
            $order_reference = '';
        }
        $this->context->smarty->assign(
            array(
                'order_reference' => $order_reference,
                'eo_orderreference_token' => md5(_COOKIE_KEY_.$this->name)
            )
        );
        return $this->display(dirname(__FILE__), 'hook_fo_shopping_cart.tpl');
    }

    protected function getProfileoBannerUrl($type = 'top')
    {
        $base_url = 'http://addonsmodules.tools.profileo.com';

        $params = array(
                'mv' => $this->version,
                'psv' => _PS_VERSION_,
                'iso_lang' => $this->context->language->iso_code,
            );

        if ($type == 'bottom') {
            return $base_url.'/banner_bottom_'.$this->name.'.html?'.http_build_query($params);
        } else {
            return $base_url.'/banner_top_'.$this->name.'.html?'.http_build_query($params);
        }
    }
}
