<?php
/**
*  2017-2018 Profileo
*
*  @author    Profileo <contact@profileo.com>
*  @copyright 2017-2018 Profileo
*  @license   Profileo
*/

class PdfDeliveryControllerCore extends FrontController
{
    public $php_self = 'pdf-delivery';
    protected $display_header = false;
    protected $display_footer = false;

    public $content_only = true;

    protected $template;
    public $filename;

    public function postProcess()
    {
        if (!$this->context->customer->isLogged() && !Tools::getValue('secure_key')) {
            Tools::redirect('index.php?controller=authentication&back=pdf-invoice');
        }
        if (!(int)Configuration::get('PS_INVOICE')) {
            die(Tools::displayError('Invoices are disabled in this shop.'));
        }
        $id_order = (int)Tools::getValue('id_order');

        if (Validate::isUnsignedId($id_order)) {
            $order = new Order((int)$id_order);
        } else {
            die(Tools::displayError('Order not found.'));
        }
        $this->order = $order;
    }

    public function display()
    {
        $order_invoice_list = $this->order->getInvoicesCollection();
        Hook::exec('actionPDFInvoiceRender', array('order_invoice_list' => $order_invoice_list));

        $pdf = new PDF($order_invoice_list, PDF::TEMPLATE_DELIVERY_SLIP, $this->context->smarty);
        $pdf->render();
    }
}
