<?php
/**
*  2017-2018 Profileo
*
*  @author    Profileo <contact@profileo.com>
*  @copyright 2017-2018 Profileo
*  @license   Profileo
*/

class HistoryController extends HistoryControllerCore
{
    public function initContent()
    {
        parent::initContent();

        if ($orders = Order::getCustomerOrders($this->context->customer->id)) {
            $mod_eo_orderreference = Module::getInstanceByName('eo_orderreference');
            foreach ($orders as &$order) {
                $myOrder = new Order((int)$order['id_order']);
                if (Validate::isLoadedObject($myOrder)) {
                    $order['virtual'] = $myOrder->isVirtual(false);
                }
                $value = $mod_eo_orderreference->getOrderRefByIdOrder((int)$order['id_order']);
                $order['customer_order_reference'] = $value;
            }
        }

        $this->context->smarty->assign(array(
            'orders' => $orders,
            'invoiceAllowed' => (int)Configuration::get('PS_INVOICE'),
            'reorderingAllowed' => !(int)Configuration::get('PS_DISALLOW_HISTORY_REORDERING'),
            'slowValidation' => Tools::isSubmit('slowvalidation')
        ));

        $this->setTemplate(_PS_THEME_DIR_.'history.tpl');
    }
}
