{*

* 2007-2013 PrestaShop

*

* NOTICE OF LICENSE

*

* This source file is subject to the Academic Free License (AFL 3.0)

* that is bundled with this package in the file LICENSE.txt.

* It is also available through the world-wide-web at this URL:

* http://opensource.org/licenses/afl-3.0.php

* If you did not receive a copy of the license and are unable to

* obtain it through the world-wide-web, please send an email

* to license@prestashop.com so we can send you a copy immediately.

*

* DISCLAIMER

*

* Do not edit or add to this file if you wish to upgrade PrestaShop to newer

* versions in the future. If you wish to customize PrestaShop for your

* needs please refer to http://www.prestashop.com for more information.

*

*  @author Buy-addons <contact@buy-addons.com>

*  @copyright  2007-2018 PrestaShop SA

*  @license    http://opensource.org/licenses/afl-3.0.php  Academic Free License (AFL 3.0)

*  International Registered Trademark & Property of PrestaShop SA

*}

<select class='form-control advance_select' name='select[{$key|escape:"htmlall":"UTF-8"}]'>

    <option value=''>{l s='- None -' mod='ba_importer'}</option>

    <optgroup label='Product Information'>
    
        <option value='4' {if $config_select_importer == '4'}selected{/if}>{l s='Product ID' mod='ba_importer'}</option>
        <option value='language' {if $config_select_importer == 'language'}selected{/if}>{l s='ISO Language (%s)' sprintf=[$isoLang] mod='ba_importer'}</option>
        <option value='iso_code' {if $config_select_importer == 'iso_code'}selected{/if}>{l s='Currency ISO Code (%s)' sprintf=[$isoCur]  mod='ba_importer'}</option>
        
        <optgroup label='Information'>
            {foreach from=$arr_lang key=key item=row}
                <option value='name_{$key|escape:"htmlall":"UTF-8"}' {if $config_select_importer == 'name_{$key|escape:"htmlall":"UTF-8"}'}selected{/if}>{l s='Product Name (%s)' sprintf = $row mod='ba_importer'}</option>
            {/foreach}
            <option value='2' {if $config_select_importer == '2'}selected{/if}>{l s='Reference code' mod='ba_importer'}</option>
            <option value='15' {if $config_select_importer == '15'}selected{/if}>{l s='EAN13 or JAN barcode' mod='ba_importer'}</option>
            <option value='16' {if $config_select_importer == '16'}selected{/if}>{l s='UPC barcode' mod='ba_importer'}</option>
            <option value='status' {if $config_select_importer == 'status'}selected{/if}>{l s='Status (0, N, No = No; 1, Y, Yes = Yes)' mod='ba_importer'}</option>
            <option value='visibility' {if $config_select_importer == 'visibility'}selected{/if}>{l s='Visibility (Everywhere, Catalog only, Search only, Nowhere)' mod='ba_importer'}</option>
            <option value='available_for_order' {if $config_select_importer == 'available_for_order'}selected{/if}>{l s='Available for order (0, N, No = No, 1; Y, Yes = Yes)' mod='ba_importer'}</option>
            <option value='condition' {if $config_select_importer == 'condition'}selected{/if}>{l s='Condition (New, Used, Refurbished)' mod='ba_importer'}</option>
            {foreach from=$arr_lang key=key item=row}
                <option value='short_{$key|escape:"htmlall":"UTF-8"}' {if $config_select_importer == 'short_{$key|escape:"htmlall":"UTF-8"}'}selected{/if}>{l s='Product Short Description (%s)' sprintf = $row mod='ba_importer'}</option>
            
                <option value='description_{$key|escape:"htmlall":"UTF-8"}' {if $config_select_importer == 'description_{$key|escape:"htmlall":"UTF-8"}'}selected{/if}>{l s='Product Full Description (%s)' sprintf = $row mod='ba_importer'}</option>
            
                <option value='tags_{$key|escape:"htmlall":"UTF-8"}' {if $config_select_importer == 'tags_{$key|escape:"htmlall":"UTF-8"}'}selected{/if}>{l s='Product Tags (%s)' sprintf = $row mod='ba_importer'}</option>
            {/foreach}
        </optgroup>
        
        <optgroup label='Prices'>
            <option value='7' {if $config_select_importer == '7'}selected{/if}>{l s='Pre-tax wholesale price' mod='ba_importer'}</option>
            <option value='8' {if $config_select_importer == '8'}selected{/if}>{l s='Pre-tax retail price' mod='ba_importer'}</option>
            <option value='price_id_tax_rules_group' {if $config_select_importer == 'price_id_tax_rules_group'}selected{/if}>{l s='Tax id' mod='ba_importer'}</option>
            <option value='price_unit_price_ratio' {if $config_select_importer == 'price_unit_price_ratio'}selected{/if}>{l s='Unit price (tax excl.)' mod='ba_importer'}</option>
            <option value='price_unity' {if $config_select_importer == 'price_unity'}selected{/if}>{l s='Unity' mod='ba_importer'}</option>
            <option value='price_on_sale' {if $config_select_importer == 'price_on_sale'}selected{/if}>{l s='Display the "on sale" icon on the product page. (0, N, No = No, 1; Y, Yes = Yes)' mod='ba_importer'}</option>
        </optgroup>
        
        <optgroup label='SEO'>
            {foreach from=$arr_lang key=key item=row}
                <option value='metaTitle_{$key|escape:"htmlall":"UTF-8"}' {if $config_select_importer == 'metaTitle_{$key|escape:"htmlall":"UTF-8"}'}selected{/if}>{l s='Meta title (%s)' sprintf = $row mod='ba_importer'}</option>
                <option value='metaDes_{$key|escape:"htmlall":"UTF-8"}' {if $config_select_importer == 'metaDes_{$key|escape:"htmlall":"UTF-8"}'}selected{/if}>{l s='Meta description (%s)' sprintf = $row mod='ba_importer'}</option>
                <option value='metaKey_{$key|escape:"htmlall":"UTF-8"}' {if $config_select_importer == 'metaKey_{$key|escape:"htmlall":"UTF-8"}'}selected{/if}>{l s='Meta keywords (%s)' sprintf = $row mod='ba_importer'}</option>
                <option value='friendlyURL_{$key|escape:"htmlall":"UTF-8"}' {if $config_select_importer == 'friendlyURL_{$key|escape:"htmlall":"UTF-8"}'}selected{/if}>{l s='Friendly URL (%s)' sprintf = $row mod='ba_importer'}</option>
            {/foreach}
        </optgroup>
        
        <optgroup label='Associations'>
            <option value='main_category'  {if $config_select_importer == 'main_category'}selected{/if}>{l s='Name of default Category ' mod='ba_importer'}</option>
            <option value='category_associated' {if $config_select_importer == 'category_associated'}selected{/if}>{l s='Name of Associated categories ' mod='ba_importer'}</option>
            <option value='manufacturer' {if $config_select_importer == 'manufacturer'}selected{/if}>{l s='Manufacturer Name' mod='ba_importer'}</option>
        </optgroup>
        
        <optgroup label='Shipping'>
            <option value='shipping_width'  {if $config_select_importer == 'shipping_width'}selected{/if}>{l s='Package width (cm)' mod='ba_importer'}</option>
            <option value='shipping_height' {if $config_select_importer == 'shipping_height'}selected{/if}>{l s='Package height (cm)' mod='ba_importer'}</option>
            <option value='shipping_depth' {if $config_select_importer == 'shipping_depth'}selected{/if}>{l s='Package depth (cm)' mod='ba_importer'}</option>
            <option value='shipping_weight' {if $config_select_importer == 'shipping_weight'}selected{/if}>{l s='Package weight (kg)' mod='ba_importer'}</option>
            <option value='shipping_additional_shipping_cost' {if $config_select_importer == 'shipping_additional_shipping_cost'}selected{/if}>{l s='Additional shipping fees (for a single item) (tax excl.)' mod='ba_importer'}</option>
        </optgroup>
        
        <optgroup label='Quantities'>
            <option value='advanced_stock_management'  {if $config_select_importer == 'advanced_stock_management'}selected{/if}>{l s='I want to use the advanced stock management system (0, N, No = No, 1; Y, Yes = Yes)' mod='ba_importer'}</option>
            <option value='14'  {if $config_select_importer == '14'}selected{/if}>{l s='Quantities' mod='ba_importer'}</option>
            {foreach from=$arr_lang key=key item=row}
                <option value='out_of_stock_{$key|escape:"htmlall":"UTF-8"}' {if $config_select_importer == 'out_of_stock_{$key|escape:"htmlall":"UTF-8"}'}selected{/if}>{l s='When out of stock (0 = Deny orders, 1 = Allow orders, 2 = Default: Deny orders as set in the Products Preferences page) (%s)' sprintf = $row mod='ba_importer'}</option>
                <option value='available_now_{$key|escape:"htmlall":"UTF-8"}' {if $config_select_importer == 'available_now_{$key|escape:"htmlall":"UTF-8"}'}selected{/if}>{l s='Displayed text when in-stock (%s)' sprintf = $row mod='ba_importer'}</option>
            {/foreach}
            <option value='available_later'  {if $config_select_importer == 'available_later'}selected{/if}>{l s='Displayed text when backordering is allowed' mod='ba_importer'}</option>
        </optgroup>
        
        <optgroup label='Images'>
            {foreach from=$arr_lang key=key item=row}
                <option value='mainImage_{$key|escape:"htmlall":"UTF-8"}' {if $config_select_importer == 'mainImage_{$key|escape:"htmlall":"UTF-8"}'}selected{/if}>{l s='Product Main Image (%s)' sprintf = $row mod='ba_importer'}</option>
                <option value='additionImage_{$key|escape:"htmlall":"UTF-8"}' {if $config_select_importer == 'additionImage_{$key|escape:"htmlall":"UTF-8"}'}selected{/if}>{l s='Product Addition Image (%s)' sprintf = $row mod='ba_importer'}</option>
            {/foreach}
        </optgroup>
        
        <optgroup label='Supplier'>
            <option value='supplier' {if $config_select_importer == 'supplier'}selected{/if}>{l s='Supplier Name' mod='ba_importer'}</option>
        </optgroup>
        
    </optgroup>

    <optgroup label='Feature'>
        
        {foreach from=$advance_feature item=row}
            {foreach from=$arr_lang key=key item=value}
                {assign var="feature_id" value="feature_{$row.id_feature|escape:"htmlall":"UTF-8"}_{$key|escape:"htmlall":"UTF-8"}"}
                <option value='{$feature_id|escape:"htmlall":"UTF-8"}' {if $config_select_importer == $feature_id }selected{/if}>{$row.name|escape:"htmlall":"UTF-8"} ({$value|escape:"htmlall":"UTF-8"})</option>
            {/foreach}
        {/foreach}

    </optgroup>
    
    <optgroup label='Customization'>
        {foreach from=$arr_lang key=key item=row}
            <option value='uploadable_files_{$key|escape:"htmlall":"UTF-8"}' {if $config_select_importer == 'uploadable_files_{$key|escape:"htmlall":"UTF-8"}'}selected{/if}>{l s='Name of uploadable files (%s)' sprintf = $row mod='ba_importer'}</option>
            <option value='text_fields_{$key|escape:"htmlall":"UTF-8"}' {if $config_select_importer == 'text_fields_{$key|escape:"htmlall":"UTF-8"}'}selected{/if}>{l s='Name of text files (%s)' sprintf = $row mod='ba_importer'}</option>
        {/foreach}
    </optgroup>
    
    <optgroup label='Attributes'>
        
        {foreach from=$ba_combination item=row}
            {assign var="combination_group_id" value="combination_{$row.id_attribute_group|escape:"htmlall":"UTF-8"}"}
            <option value='{$combination_group_id|escape:"htmlall":"UTF-8"}' {if $config_select_importer == $combination_group_id}selected{/if}>{$row.name|escape:"htmlall":"UTF-8"}</option>
        {/foreach}

    </optgroup>
    <optgroup label='Combination'>
        
        <option value='ba_combination_reference' {if $config_select_importer == 'ba_combination_reference'}selected{/if}>{l s='Reference code' mod='ba_importer'}</option>
        <option value='ba_combination_ean13' {if $config_select_importer == 'ba_combination_ean13'}selected{/if}>{l s='EAN13 or JAN barcode' mod='ba_importer'}</option>
        <option value='ba_combination_upc' {if $config_select_importer == 'ba_combination_upc'}selected{/if}>{l s='UPC barcode' mod='ba_importer'}</option>
        <option value='ba_combination_wholesale_price' {if $config_select_importer == 'ba_combination_wholesale_price'}selected{/if}>{l s='Wholesale price' mod='ba_importer'}</option>
        <option value='ba_combination_price' {if $config_select_importer == 'ba_combination_price'}selected{/if}>{l s='Impact on price' mod='ba_importer'}</option>
        <option value='ba_combination_weight' {if $config_select_importer == 'ba_combination_weight'}selected{/if}>{l s='Impact on weight' mod='ba_importer'}</option>
        <option value='ba_combination_unit_price_impact' {if $config_select_importer == 'ba_combination_unit_price_impact'}selected{/if}>{l s='Impact on unit price' mod='ba_importer'}</option>
        <option value='ba_combination_minimal_quantity' {if $config_select_importer == 'ba_combination_minimal_quantity'}selected{/if}>{l s='Minimum quantity' mod='ba_importer'}</option>
        <option value='ba_combination_available_date' {if $config_select_importer == 'ba_combination_available_date'}selected{/if}>{l s='Availability date (Y-m-d)' mod='ba_importer'}</option>
        <option value='ba_combination_image' {if $config_select_importer == 'ba_combination_image'}selected{/if}>{l s='Image' mod='ba_importer'}</option>
        <option value='ba_combination_default_on' {if $config_select_importer == 'ba_combination_default_on'}selected{/if}>{l s='Default (0, N, No = No, 1; Y, Yes = Yes)' mod='ba_importer'}</option>

    </optgroup>
    
    <optgroup label='Warehouses'>
        {foreach from=$ba_warehouse item=row}
        
            {assign var="warehouse_id" value="warehouse_{$row.id_warehouse|escape:"htmlall":"UTF-8"}"}
            <option value='{$warehouse_id|escape:"htmlall":"UTF-8"}' disabled>{$row.name|escape:"htmlall":"UTF-8"}</option>
            <option value='{$warehouse_id|escape:"htmlall":"UTF-8"}_quantity' {if $config_select_importer == "{$warehouse_id|escape:"htmlall":"UTF-8"}_quantity"}selected{/if}>{l s='%s: Stock' sprintf=$row.name mod='ba_importer'}</option>
            <option value='{$warehouse_id|escape:"htmlall":"UTF-8"}_usable' {if $config_select_importer == "{$warehouse_id|escape:"htmlall":"UTF-8"}_usable"}selected{/if}>{l s='%s: Usable for sale? (0, N, No = No, 1; Y, Yes = Yes)' sprintf=$row.name mod='ba_importer'}</option>
            <option value='{$warehouse_id|escape:"htmlall":"UTF-8"}_price' {if $config_select_importer == "{$warehouse_id|escape:"htmlall":"UTF-8"}_price"}selected{/if}>{l s='%s: Unit price (tax excl.)' sprintf=$row.name mod='ba_importer'}</option>
            <option value='{$warehouse_id|escape:"htmlall":"UTF-8"}_iso_code' {if $config_select_importer == "{$warehouse_id|escape:"htmlall":"UTF-8"}_iso_code"}selected{/if}>{l s='%s: Currency ISO Code (%s)' sprintf=[$row.name, $isoCur] mod='ba_importer'}</option>
            <option value='{$warehouse_id|escape:"htmlall":"UTF-8"}_label' {if $config_select_importer == "{$warehouse_id|escape:"htmlall":"UTF-8"}_label"}selected{/if}>{l s='%s: Name of label' sprintf=$row.name mod='ba_importer'}</option>
        {/foreach}
    </optgroup>

</select>